/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.mcef.utilities.download;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.zip.GZIPInputStream;
import net.montoyo.mcef.MCEF;
import net.montoyo.mcef.utilities.IProgressListener;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;

public class ModernDownload {
    protected static final String[] urls = new String[]{"cinemamod:https://github.com/CinemaMod/cinemamod-jcefbuild/releases/download/1.0.8/", "jcefmvn:https://github.com/jcefmaven/jcefbuild/releases/download/1.0.46/"};

    static double toMB(int src) {
        return (double)((int)((double)src * 1.0E-5)) / 10.0;
    }

    public static boolean download(IProgressListener listener) {
        String post;
        String os;
        listener.onTaskChanged("1:Downloading from Git");
        Path librariesPath = Paths.get(System.getProperty("cinemamod.libraries.path"), new String[0]);
        File info = new File(librariesPath + "/info.txt");
        String existing = "";
        if (info.exists()) {
            try {
                FileInputStream fis = new FileInputStream(info);
                existing = new String(((InputStream)fis).readAllBytes());
                ((InputStream)fis).close();
            }
            catch (Throwable err) {
                err.printStackTrace();
            }
        }
        Object platform = (os = System.getProperty("os.name").toLowerCase(Locale.ROOT)).contains("win") ? "windows" : (os.contains("mac") ? "macosx" : (os.contains("linux") ? "linux" : "unknown"));
        platform = (String)platform + "-" + System.getProperty("os.arch");
        String string = post = System.getProperty("os.arch").contains("64") ? "64" : "32";
        Object plat = os.contains("win") ? "win" + post : (os.contains("mac") ? "mac" + post : (os.contains("linux") ? "linux" + post : "unknown"));
        boolean downloaded = false;
        listener.onTaskChanged("2:Downloading");
        String[] allUrls = new String[urls.length + MCEF.FALLBACK_URLS_GIT.length];
        allUrls[0] = urls[0];
        System.arraycopy(MCEF.FALLBACK_URLS_GIT, 0, allUrls, 1, MCEF.FALLBACK_URLS_GIT.length);
        allUrls[allUrls.length - 1] = urls[1];
        String urlSelected = null;
        for (String urlStr : allUrls) {
            if (existing.equals(urlStr)) {
                return true;
            }
            String[] split = urlStr.split(":", 2);
            try {
                int incr;
                String root = "bin/lib/" + (String)plat;
                int count = 0;
                listener.onTaskChanged("3:" + split[0]);
                URL url = new URL(split[1] + (String)platform + ".tar.gz");
                URLConnection connection = url.openConnection();
                int len = connection.getContentLength();
                InputStream stream = connection.getInputStream();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buf = new byte[16384];
                int progress = 0;
                while ((incr = stream.read(buf)) != -1) {
                    listener.onTaskChanged("3:" + split[0] + " (" + ModernDownload.toMB(progress += incr) + "MB of " + ModernDownload.toMB(len) + "MB)");
                    baos.write(buf, 0, incr);
                    listener.onProgressed((double)progress / (double)len);
                }
                stream.close();
                TarArchiveInputStream tarArchive = new TarArchiveInputStream((InputStream)new GZIPInputStream(new ByteArrayInputStream(baos.toByteArray())));
                while (tarArchive.getNextTarEntry() != null) {
                    TarArchiveEntry entry = tarArchive.getCurrentEntry();
                    if (entry.isDirectory() || !entry.getName().startsWith(root)) continue;
                    ++count;
                }
                tarArchive.close();
                tarArchive = new TarArchiveInputStream((InputStream)new GZIPInputStream(new ByteArrayInputStream(baos.toByteArray())));
                listener.onTaskChanged("2:Extract from " + split[0]);
                int i = 0;
                while (tarArchive.getNextTarEntry() != null) {
                    TarArchiveEntry entry = tarArchive.getCurrentEntry();
                    listener.onTaskChanged("3:" + entry.getName());
                    if (!entry.getName().startsWith(root)) continue;
                    if (entry.isDirectory()) {
                        File localFile = new File(librariesPath + "/" + entry.getName().substring(root.length()));
                        localFile.mkdirs();
                        continue;
                    }
                    byte[] data = tarArchive.readAllBytes();
                    File localFile = new File(librariesPath + "/" + entry.getName().substring(root.length()));
                    listener.onProgressed((double)i / (double)count);
                    ++i;
                    FileOutputStream outputStream = new FileOutputStream(localFile);
                    outputStream.write(data);
                    outputStream.flush();
                    outputStream.close();
                }
                urlSelected = urlStr;
                downloaded = true;
                break;
            }
            catch (Throwable throwable) {
            }
        }
        if (downloaded) {
            try {
                FileOutputStream outputStream = new FileOutputStream(info);
                outputStream.write(urlSelected.getBytes(StandardCharsets.UTF_8));
                outputStream.close();
            }
            catch (Throwable err) {
                err.printStackTrace();
            }
        }
        return downloaded;
    }
}

